function Inn(price)
{
	this.price = price;
	this.keeper = "Inn Keeper";
	this.greeting = "Hi. Welcome to my inn. It is only " + price + "$ to stay the night";
	this.exitSleep = "Thanks for the business. Come again.";
	this.exitNoSleep = price + "$ is too much for you?";
}

Inn.prototype.open = function()
{
	if (LastPush())
	{
		var innMenu = new Menu(true);
		innMenu.doWhile = InnWindow;
		innMenu.returnSelection = true;
		innMenu.addItem("Stay");
		innMenu.addItem("Leave");
		innMenu.heading = "INN";
		window.message(20, 20, 280, this.keeper, this.greeting, 0);
		KeyPressed();
		var s = innMenu.executeAlone(234, 140, 66, 2);
		if (s == 0)
		{
			this.stay();
		}
		else
		{
			this.leave();
		}
	}
}

Inn.prototype.stay = function()
{
	Game.messageopen = false;
	if (Game.money >= this.price)
	{
		Message(20, 20, 280, this.keeper, "Thank you. Sleep well.", 0);
		Game.money -= this.price;
		RenderMap();
		FadeToColor(2000, Colors.Black);
		RenderMap();
		FadeFromColor(2000, Colors.Black);
		Message(20, 20, 280, this.keeper, this.exitSleep, 0);
	}
	else
	{
		Message(20, 20, 280, this.keeper, "I'm sorry, but you don't have enough money to stay", 0);
	}
}

Inn.prototype.leave = function()
{
	Game.messageopen = false;
	Message(20, 20, 280, this.keeper, this.exitNoSleep, 0);
}

function InnWindow()
{
	window.drawMessage();
	window.drawWindow(194, 100, 106, 8, true, "FUNDS");
	font.drawText(298, 100, Game.money + "$", "right");
}

// Creates a new shop
function Shop(type)
{
	this.itemMenu = new Menu(true);
	this.keeper = "Shop Keeper";
	if (type == undefined)
	{
		this.type = "Item";
	}
	else
		this.type = type;
	this.greeting = "Hi. Welcome to my " + this.type + " shop. What can I do for you?";
	this.itemBought = false;
	this.itemMenu.returnSelection = true;
	this.itemMenu.doWhile = ShopScreen;
	this.itemMenu.onRight = "Cost";
	this.itemMenu.icons = true;
	this.itemMenu.spacing = 14;
	this.itemMenu.heading = "ITEM";
	this.itemMenu.indent = 6;
	this.itemMenu.style = "Top";
}

Shop.prototype.open = function(skip)
{
	if (LastPush())
	{
		if (skip == undefined || skip == false)
		{
			Game.shop = this;
			Message(20, 20, 280, this.keeper, this.greeting, 0);
		}
		KeyPressed();
		var shopMenu = new Menu(true);
		shopMenu.returnSelection = true;
		shopMenu.addItem("Buy");
		shopMenu.addItem("Sell");
		shopMenu.addItem("Leave");
		shopMenu.heading = "STORE";
		shopMenu.items[1].enabled = false;
		ShopWindow();
		this.func = shopMenu.executeAlone(141, 113, 38, 3);
		switch (this.func)
		{
			case 0:
				this.buy();
				break;
			case 1:
				this.sell();
				break;
			default:
				this.leave();
				break;
		}
	}
}

Shop.prototype.addItem = function(item)
{
	this.itemMenu.items[this.itemMenu.items.length] = item;
	this.itemMenu.items[this.itemMenu.items.length - 1].link = this.itemDetails;
	this.itemMenu.items[this.itemMenu.items.length - 1].enabled = true;
}

Shop.prototype.buy = function()
{
	ShopScreen();
	var s = this.itemMenu.executeAlone(20, 54, 160, 7);
	if (s == -1)
	{
		this.open(true);
	}
	else
		this.itemDetails(this.itemMenu.items[this.itemMenu.selection]);
}

Shop.prototype.sell = function()
{
	// Display item screen
}

Shop.prototype.leave = function()
{
	if (this.itemBought == true)
	{
		; // exitBuy message
	}
	else
	{
		; // exitNoBuy message
	}
}

Shop.prototype.itemDetails = function(item)
{
	var amount = 1;
	switch (this.func)
	{
		case 0:
			this.itemMenu.doWhile();
			this.itemMenu.draw(20, 54, 160, 7, "Away");
			break;
		case 1:
			break;
	}
	var background = GrabImage(0, 0, 320, 240);
	Game.menuopen = true;
	while (Game.menuopen)
	{
		Interrupt();
		background.blit(0, 0);
		window.drawWindow(130, 113, 60, 44, true, "INFO");
		font.drawText(130, 113, "Funds");
		font.drawText(188, 125, Game.money - (item.cost * amount) + "$", "right");
		font.drawText(130, 137, "Amount");
		font.drawText(164, 149, "x" + amount);
		FlipScreen();
		if (LastPush())
		{
			if (IsKeyPressed(Game.accept))
			{
				KeyPressed();
				item.add(amount, Game.items);
				Game.money -= item.cost * amount;
				Game.menuopen = false;
				if (this.itemBought == false)
				{
					this.itemBought = true;
				}
			}
			if (IsKeyPressed(Game.cancel))
			{
				KeyPressed(false);
				Game.menuopen = false;
			}
			if (IsKeyPressed(KEY_RIGHT))
			{
				KeyPressed();
				amount ++;
				if (Game.money - (item.cost * amount) < 0)
				{
					amount --;
				}
			}
			if (IsKeyPressed(KEY_LEFT))
			{
				KeyPressed();
				amount --;
				if (amount < 1)
				{
					amount ++;
				}
			}
			if (IsKeyPressed(KEY_UP))
			{
				KeyPressed();
				amount += 10;
				if (Game.money - (item.cost * amount) < 0)
				{
					amount -= 10;
				}
				if (amount > 99)
				{
					amount = 99;
				}
			}
			if (IsKeyPressed(KEY_DOWN))
			{
				KeyPressed();
			}
		}
	}
	if (this.func == 0)
	{
		this.buy();
	}
	if (this.func == 1)
	{
		this.sell();
	}
}

function ShopWindow()
{
	var shop = Game.shop;
	DrawBG();
	window.drawWindow(20, 20, 66, 10, true, "MENU");
	font.drawText(20, 20, shop.type);
	window.drawWindow(107, 20, 196, 10, "Top", "HELP");
	font.drawText(107, 20, "What can I do for you?");
}

function ShopScreen()
{
	var shop = Game.shop;
	DrawBG();
	window.drawWindow(20, 20, 66, 10, true, "MENU");
	font.drawText(20, 20, shop.type);
	window.drawWindow(107, 20, 196, 10, "Top", "HELP");
	if (shop.func == 0)
	{
		font.drawText(107, 20, "Which one do you want?");
	}
	else
		font.drawText(107, 20, "Which one do you want to sell?");
	window.drawWindow(198, 54, 103, 96, "Top", "INFO");
	font.drawText(198, 54, "Funds");
	font.drawText(301, 54, Game.money + "$", "right");
	font.drawText(198, 66, "Equipped:");
	font.drawText(198, 78, "Stock:");
	window.drawWindow(20, 171, 280, 49, true, "PARTY");
	font.drawText(160, 190, "Put Party display here", "center");
}

// If event is off, evaluates the effect and tells you about it
function Treasure(text, effect, event)
{
	if (!Event(event))
	{
		Message(20, 20, 280, "", "Empty...", 0);
	}
	else
	{
		Message(20, 20, 280, "", text, 0);
		eval(effect);
		Game.events[event] = true;
	}
}

// If event is off, evaluates the effect and doesn't tell you about it
function Switch(effect, event)
{
	if (Event(event))
	{
		eval(effect);
		Game.events[event] = true;
	}
}

// Checks to see if event is on
function Event(event)
{
	if (!Game.events[event])
	{
		return true;
	}
	else
		return false;
}